//--------------------------------------------------------------------------------------
// Created by TunerPro. Hand editing is *not* recommended or supported.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
//--------------------------------- HEADER ------------------------------------
//--------------------------------------------------------------------------------------

{
	fDefFrmtVers             =1.21;
	strDefVersion            =Version V4.01;
	strDefTitle              =$8D Super AUJP V4 Datastream Definition;
	strAuthor                =John Pell;
	strEngine                =L98 5.7L TPI (LB9 && L98);
	strYear                  =1991 , 1992;
	strVINCode               =8 & F;
	strCodeMask              =AUJP "A100" Datastream" ;
	strComments              =(12-13,16,39-40,41-42,47-48,49-50,51,52-53) WRONG;
	iBaud                    =8192;
	dwFlags                  =0x00000000;
	dwCSID                   =0x0005618E;
	btNumDumpRequests        =4;

	strCommandName           =Mode 1 ALDL Dump Request;
	rgbtCommand              =F4, 56, 01;
	iTotalBytesInCommand     =4;
	bChecksumCommand         =1;
	iNumBytesInPayload       =63;
	iNumBytesBeforePayload   =3;
	bMaster                  =1;
	bMonitor                 =1;
	iChainTo                 =-1;

	strCommandName           =Clear Trouble Codes (Mode 10);
	rgbtCommand              =F4, 56, 0A;
	iTotalBytesInCommand     =4;
	bChecksumCommand         =1;
	iNumBytesInPayload       =3;
	iNumBytesBeforePayload   =0;
	bMaster                  =0;
	bMonitor                 =0;
	iChainTo                 =-1;

	strCommandName           =Mode 2, Selectable Dump;
	rgbtCommand              =F4, 58, 02, 00, 00;
	iTotalBytesInCommand     =6;
	bChecksumCommand         =1;
	iNumBytesInPayload       =63;
	iNumBytesBeforePayload   =3;
	bMaster                  =0;
	bMonitor                 =0;
	iChainTo                 =-1;

	strCommandName           =Mode 3, 0-8 Select Dump;
	rgbtCommand              =F4, 58, 03, 00, 00;
	iTotalBytesInCommand     =6;
	bChecksumCommand         =1;
	iNumBytesInPayload       =63;
	iNumBytesBeforePayload   =3;
	bMaster                  =0;
	bMonitor                 =0;
	iChainTo                 =-1;
}

//--------------------------------------------------------------------------------------
//---------------------------------- DASH -------------------------------------
//--------------------------------------------------------------------------------------

{
	dwItemType               =6;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =0;

	btNumGauges              =6;
	strIDsDisplayed          =209,43,46,219,217,226,;
	btNumMonitors            =4;
	strMonsDisplayed         =0,57,44,120,;
}

//--------------------------------------------------------------------------------------
//--------------------------------- VALUES ------------------------------------
//--------------------------------------------------------------------------------------

{
	dwItemType               =1;
	strItemComments          =Double Byte ID Value;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =0;

	btByteNumber             =0;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.195313;
	dOffset                  =0.000000;
	strItemTitle             =Calc'd VE;
	strUnitLabel             =VE %;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =512;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Battery Volts;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =90;

	btByteNumber             =34;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.100000;
	dOffset                  =0.000000;
	strItemTitle             =Battery Volts;
	strUnitLabel             =Volts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Fuel Pump Volts;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =89;

	btByteNumber             =35;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.100000;
	dOffset                  =0.000000;
	strItemTitle             =Fuel Pump Volts;
	strUnitLabel             =Volts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Deg C = (N * 0.75) - 40  or  Deg F = (N * 1.35) + 40 \\ was SU Coolant Temp;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =42;

	btByteNumber             =9;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =6;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =EGT Deg F;
	strUnitLabel             =Deg F;
	dwAlarmHigh              =221;
	bAlarmHighENable         =1;
	dwAlarmLow               =114;
	bAlarmLowEnable          =1;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =227;
}

{
	dwItemType               =1;
	strItemComments          =STD Datastream Item;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =231;

	btByteNumber             =9;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.750000;
	dOffset                  =-40.000000;
	strItemTitle             =Coolant Temp at Startup;
	strUnitLabel             =Deg C;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Current Coolant Temperature;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =41;

	btByteNumber             =8;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.750000;
	dOffset                  =-40.000000;
	strItemTitle             =Coolant Temp;
	strUnitLabel             =Deg C;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Alarms will change color for lower than min TPS Volts and will Alarm high for WOT threshold;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =43;

	btByteNumber             =10;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.019608;
	dOffset                  =0.000000;
	strItemTitle             =TPS Volts;
	strUnitLabel             =Volts;
	dwAlarmHigh              =234;
	bAlarmHighENable         =1;
	dwAlarmLow               =20;
	bAlarmLowEnable          =1;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =230;

	btByteNumber             =10;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.019690;
	dOffset                  =14.000000;
	strItemTitle             =SIM NB LC-1;
	strUnitLabel             =SIM NB AFR;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =TPS % of scale;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =64;

	btByteNumber             =24;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.392160;
	dOffset                  =0.000000;
	strItemTitle             =TPS %;
	strUnitLabel             =%;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =For use only with S_AUJP V4 (7,969 RPM Maximum);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =225;

	btByteNumber             =25;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =31.250000;
	dOffset                  =0.000000;
	strItemTitle             =RPM (/31.25) to 8K;
	strUnitLabel             =RPM;
	dwAlarmHigh              =192;
	bAlarmHighENable         =1;
	dwAlarmLow               =16;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =RPM / 25;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =44;

	btByteNumber             =11;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =25.000000;
	dOffset                  =0.000000;
	strItemTitle             =RPM (/25);
	strUnitLabel             =RPM /25;
	dwAlarmHigh              =220;
	bAlarmHighENable         =1;
	dwAlarmLow               =12;
	bAlarmLowEnable          =1;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =RPM / 12.5 for higher RPM Scale;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =65;

	btByteNumber             =25;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =12.500000;
	dOffset                  =0.000000;
	strItemTitle             =RPM (/12.5);
	strUnitLabel             =RPM /12.5;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =THIS CALCULATION CAN'T BE DONE IN TP (No RPM);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =45;

	btByteNumber             =12;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.152600;
	dOffset                  =0.000000;
	strItemTitle             =Ref Period;
	strUnitLabel             =Usec;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =1278;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Current Vehicle Speed from VSS input;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =46;

	btByteNumber             =14;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =Speed;
	strUnitLabel             =MPH;
	dwAlarmHigh              =85;
	bAlarmHighENable         =1;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =RPM / MPH Formula Wrong, Can't do in TP;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =56;

	btByteNumber             =16;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =NV RATIO;
	strUnitLabel             =RPM/MPH;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Filtered O2 sensor output;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =57;

	btByteNumber             =17;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =4.420000;
	dOffset                  =0.000000;
	strItemTitle             =o2 Sensor Filtered;
	strUnitLabel             =mVolts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Number of times the O2 sensor has crossed the Stoich point.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =58;

	btByteNumber             =18;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =3;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =o2 CrossCounts;
	strUnitLabel             =XCounts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Min to 127 = Removing Fuel, 128=OK, 129-Max = Adding Fuel ;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =59;

	btByteNumber             =19;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =BLM (Fine);
	strUnitLabel             =Counts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Min to 127 = Removing Fuel, 128=OK, 129-Max = Adding Fuel ;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =60;

	btByteNumber             =20;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =BLM (Main);
	strUnitLabel             =Counts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =0-16 Cells;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =61;

	btByteNumber             =21;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =BLM Cell #;
	strUnitLabel             =Cell;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =16;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Min to 127 = Removing Fuel, 128=OK, 129-Max = Adding Fuel ;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =62;

	btByteNumber             =22;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =BLM Integrator;
	strUnitLabel             =Counts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =More Counts = IAC Open More;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =63;

	btByteNumber             =23;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =IAC Position (Idle);
	strUnitLabel             =Counts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Map sensor Voltage input;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =66;

	btByteNumber             =26;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.019608;
	dOffset                  =0.000000;
	strItemTitle             =MAP Volts;
	strUnitLabel             =Volts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =calculated using 100 scale / 255;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =209;

	btByteNumber             =26;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.392156;
	dOffset                  =0.000000;
	strItemTitle             =MAP Kpa;
	strUnitLabel             =Kpa;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =USES LOOKUP TABLE, Mainifold Air Temp Sensor;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =86;

	btByteNumber             =30;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =6;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =MAT (Air Temp);
	strUnitLabel             =Deg C;
	dwAlarmHigh              =100;
	bAlarmHighENable         =1;
	dwAlarmLow               =40;
	bAlarmLowEnable          =1;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =87;
}

{
	dwItemType               =1;
	strItemComments          =Current Run Time in SECONDS = ([N52]*256 + [N53]);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =88;

	btByteNumber             =52;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =Engine Run Time;
	strUnitLabel             =Seconds;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =16383;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =%DUTY CYCLE = N/2.56;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =92;

	btByteNumber             =31;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.003906;
	dOffset                  =0.000000;
	strItemTitle             =EGR Duty Cycle;
	strUnitLabel             =% DC;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          = %DUTY CYCLE = N/2.56;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =93;

	btByteNumber             =32;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.003906;
	dOffset                  =0.000000;
	strItemTitle             =CCP Duty Cycle;
	strUnitLabel             =% DC;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Commanded Idle Speed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =94;

	btByteNumber             =25;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =12.500000;
	dOffset                  =0.000000;
	strItemTitle             =Idle Speed Commanded;
	strUnitLabel             =RPM;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Used for the "WB AFR" for Multi WB hack from 1981TTA & Z69.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =113;

	btByteNumber             =37;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =IAC Min Learned Position (Keep Alive);
	strUnitLabel             =Steps;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Use to see Counts when using WB Patch or S_AUJP V4.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =217;

	btByteNumber             =37;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =WB AFR (Raw Data);
	strUnitLabel             =Raw Counts;
	dwAlarmHigh              =147;
	bAlarmHighENable         =1;
	dwAlarmLow               =79;
	bAlarmLowEnable          =1;
	iRangeHigh               =160;
	iRangeLow                =110;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =AFR when using the WB Patch RAW option 0-5V = 7.35-22.39 :1;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =216;

	btByteNumber             =37;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.058980;
	dOffset                  =7.350000;
	strItemTitle             =WB AFR (LC-1 0-5V Raw);
	strUnitLabel             =AFR;
	dwAlarmHigh              =130;
	bAlarmHighENable         =1;
	dwAlarmLow               =79;
	bAlarmLowEnable          =1;
	iRangeHigh               =255;
	iRangeLow                =90;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =For use with the WB Patch reads 10 to 20:1 AFR range.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =226;

	btByteNumber             =37;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.100000;
	dOffset                  =0.000000;
	strItemTitle             =WB AFR Output;
	strUnitLabel             =AFR;
	dwAlarmHigh              =150;
	bAlarmHighENable         =1;
	dwAlarmLow               =110;
	bAlarmLowEnable          =1;
	iRangeHigh               =160;
	iRangeLow                =120;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Not used for AUJP, No sensor installed or connected.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =114;

	btByteNumber             =38;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.750000;
	dOffset                  =40.000000;
	strItemTitle             =Oil Temp;
	strUnitLabel             =Deg C;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Formula for Output is Correct;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =115;

	btByteNumber             =39;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.351600;
	dOffset                  =0.000000;
	strItemTitle             =Total Unlimited SA (Rel TDC);
	strUnitLabel             =Degrees SA;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =256;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Formula for Output is Wrong (I think);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =116;

	btByteNumber             =41;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.351600;
	dOffset                  =0.000000;
	strItemTitle             =Total Unlimited SA (Rel REF);
	strUnitLabel             =Degrees SA;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =256;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Number of Counts the Knock sensor has registered.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =117;

	btByteNumber             =43;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =Knock Counts;
	strUnitLabel             =Counts;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Formula for Output is Probably Wrong (I think) Amount of Retard from Knock.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =118;

	btByteNumber             =44;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =0.175781;
	dOffset                  =0.000000;
	strItemTitle             =Knock Retard;
	strUnitLabel             =Deg Retard;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Correct Function 0.015258789 ;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =119;

	btByteNumber             =45;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.015259;
	dOffset                  =0.000000;
	strItemTitle             =Injector BPW;
	strUnitLabel             =mSeconds;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =120;

	btByteNumber             =47;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =1;
	dFactor                  =6553.600000;
	dOffset                  =0.000000;
	strItemTitle             =AFR Commanded;
	strUnitLabel             =AFR Commanded;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =328;
	iRangeLow                =655;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          = 1 cc/min=0.01585032 gal/hour (lbs/hr * 10.5=cc/min);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =121;

	btByteNumber             =49;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =15.260000;
	dOffset                  =0.000000;
	strItemTitle             =Accumulated Fuel;
	strUnitLabel             =Lb/Hr;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =16383;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Doesn't work with TP V4.13;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =122;

	btByteNumber             =51;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =1;
	dFactor                  =0.500000;
	dOffset                  =0.000000;
	strItemTitle             =Accumulated Distance;
	strUnitLabel             =Miles;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =<Comments>;
	bSeparator               =1;
	bVisible                 =1;
	dwUniqueID               =218;

	btByteNumber             =0;
	btMessageNumber          =1;
	dwItemSizeBits           =8;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =Moates A/D;
	strUnitLabel             =Units;
	dwAlarmHigh              =255;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =255;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Setup for LC-1 to use 0-5 volt range at 7.35-22.39 : 1 AFR 0.014687;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =219;

	btByteNumber             =67;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.014687;
	dOffset                  =7.350000;
	strItemTitle             =Channel 1 WB AFR;
	strUnitLabel             =AFR (10 bit);
	dwAlarmHigh              =600;
	bAlarmHighENable         =1;
	dwAlarmLow               =250;
	bAlarmLowEnable          =1;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Reads Voltage from the Moates unit.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =222;

	btByteNumber             =67;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.004883;
	dOffset                  =0.000000;
	strItemTitle             =Channel 1 WB Volts;
	strUnitLabel             =Volts (10 bit);
	dwAlarmHigh              =1020;
	bAlarmHighENable         =0;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =220;

	btByteNumber             =65;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =1.000000;
	dOffset                  =0.000000;
	strItemTitle             =Channel 2;
	strUnitLabel             =Units;
	dwAlarmHigh              =1022;
	bAlarmHighENable         =0;
	dwAlarmLow               =2;
	bAlarmLowEnable          =0;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Reads Voltage from the Moates unit.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =223;

	btByteNumber             =65;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.004883;
	dOffset                  =0.000000;
	strItemTitle             =Channel 2 Volts;
	strUnitLabel             =Volts (10 bit);
	dwAlarmHigh              =1020;
	bAlarmHighENable         =1;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Indicates AFR from the Simulated NB output (#1) on LC-1;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =221;

	btByteNumber             =69;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.004902;
	dOffset                  =14.000000;
	strItemTitle             =Channel 3 NB AFR;
	strUnitLabel             =AFR NB (10 bit);
	dwAlarmHigh              =407;
	bAlarmHighENable         =1;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =1024;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

{
	dwItemType               =1;
	strItemComments          =Reads Voltage from the Moates unit.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =224;

	btByteNumber             =69;
	btMessageNumber          =1;
	dwItemSizeBits           =16;
	dwOperation              =0;
	dFactor                  =0.488300;
	dOffset                  =0.000000;
	strItemTitle             =Channel 3 NB Volts;
	strUnitLabel             =mVolts NB (10 bit);
	dwAlarmHigh              =2240;
	bAlarmHighENable         =1;
	dwAlarmLow               =0;
	bAlarmLowEnable          =0;
	iRangeHigh               =2500;
	iRangeLow                =0;
	iLookupTableIndex        =-1;
}

//--------------------------------------------------------------------------------------
//---------------------------------- BITS -------------------------------------
//--------------------------------------------------------------------------------------

{
	dwItemType               =2;
	strItemComments          =------- ERROR WORD 1 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =1;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- ERROR WORD 1 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =2;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =ERROR 23, MAT Sensor LOW;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =3;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =ERROR 22, TPS LOW;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =4;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =ERROR 21, TPS HIGH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =5;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =ERROR 16, Not used;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =7;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =ERROR 14, CTS HIGH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =6;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =ERROR 15, CTS LOW;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =8;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =ERROR 13, Oxygen Sensor;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =Normally will indicate Error when engine is not running;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =10;

	btByteNumber             =3;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ERROR 12, No DRP;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- ERROR WORD 2 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =9;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- ERROR WORD 2 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =---------;
	strBitClearTitle         =---------;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =11;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =ERROR 35, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =12;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =ERROR 34, MAP Sensor LOW;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =13;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =ERROR 33, MAP Sensor HIGH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =14;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =ERROR 32, EGR Diagnostic;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =15;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =ERROR 31, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =16;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =ERROR 26, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =17;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =ERROR 25, MAT Sensor HIGH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =18;

	btByteNumber             =4;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ERROR 24, Vehicle Speed Sensor (VSS);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- ERROR WORD 3 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =19;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- ERROR WORD 3 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =Usually just a checksum error. Recheck it and try again :);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =20;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =ERROR 51, PROM Error;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =21;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =ERROR 46, VATS Failed;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FAIL;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =22;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =ERROR 45, o2 Sensor RICH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR RICH;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =24;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =ERROR 44, o2 Sensor LEAN;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR LEAN;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =23;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =ERROR 43, ESC Failure;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =25;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =ERROR 42, EST Monitor Failure;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =26;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =ERROR 41, Cylinder Select Error;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =27;

	btByteNumber             =5;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ERROR 36, Not Used;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- ERROR WORD 4 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =28;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- ERROR WORD 4 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =29;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =ERROR 63, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =30;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =ERROR 62, Oil Temp Sensor HIGH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =31;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =ERROR 61, Not used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =32;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =ERROR 56, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =33;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =ERROR 55, Not Used;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =34;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =ERROR 54, Fuel Pump Low Voltage;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =35;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =ERROR 53, Battery Over Voltage;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =36;

	btByteNumber             =6;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ERROR 52, Oil Temp Sensor LOW;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- ERROR WORD 5 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =37;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- ERROR WORD 5 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =1;
	bVisible                 =1;
	dwUniqueID               =210;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =NEW DATAWORD Patch;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP Knock Light Patch is Installed;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =214;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Knock Light On;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =   KNOCK;
	strBitClearTitle         =No Knock;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP Knock Light Patch is Installed;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =213;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Knock Light Sensor Failed;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FAILED;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =39;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Knock Enabled (diff cool);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =KS Enabled;
	strBitClearTitle         =KS OFF;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =211;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =not used;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Yes;
	strBitClearTitle         =No;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =40;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =In MAP AE;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =In  AE MAP;
	strBitClearTitle         =No AE;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =38;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =In TPS AE;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =TPS AE ON;
	strBitClearTitle         =TPS AE Off;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =212;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =In PE;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =PE = ON;
	strBitClearTitle         =No PE;
}

{
	dwItemType               =2;
	strItemComments          =Can only be used when JP DATAWORD Patch is Installed;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =215;

	btByteNumber             =7;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =NOT USED (error 51 previous check);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =------- AIR/FUEL WORD 1 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =47;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- AIR/FUEL WORD 1 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =48;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =49;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =50;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =51;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Memory Failure (M51);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =52;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =53;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =VATS System;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FAIL;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =NOT USED;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =54;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =55;

	btByteNumber             =15;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ESC Enabled by Delta Coolant;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ENABLED;
	strBitClearTitle         =COLD;
}

{
	dwItemType               =2;
	strItemComments          =------- SC1 Input Status -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =67;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- SC1 Input Status -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =68;

	btByteNumber             =27;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =A/C  Low Pressure Switch;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =69;

	btByteNumber             =27;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Second Gear;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =OFF = Requested;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =70;

	btByteNumber             =27;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =A/C Request;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =OFF;
	strBitClearTitle         =REQUEST;
}

{
	dwItemType               =2;
	strItemComments          =Does Not control a fan output, just indicates if it is needed.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =71;

	btByteNumber             =27;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =2nd Fan Request;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =------- Input States to FMD Via SSR -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =72;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- Input States to FMD Via SSR -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =Coolant Sensor Select (1=348 Ohms, 0= 4 KOhms);
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =73;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Coolant Sensor Select;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =348 Ohms;
	strBitClearTitle         =4 KOhms;
}

{
	dwItemType               =2;
	strItemComments          =<54 mSeconds between Falling Edges;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =74;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =COP2;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON   :);
	strBitClearTitle         =OFF :(;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =75;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =EST Enabled;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ENABLED;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =WHAT IS THIS ?????;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =76;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Port, Pin 8;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =77;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Fuel Pump Enable;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =78;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =OSDC ??? (Not Used);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =79;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =IRQ Enable;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ENABLED;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =80;

	btByteNumber             =28;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Data Steering;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =BYTE 2;
	strBitClearTitle         =BYTE 1;
}

{
	dwItemType               =2;
	strItemComments          =------- NV MODE WORD 1 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =81;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- NV MODE WORD 1 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =82;

	btByteNumber             =29;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =ERR 43 EST TEST IN PROGRESS FLAG;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =IN PROGRESS;
	strBitClearTitle         =NOT RUNNING;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =83;

	btByteNumber             =29;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =SKIP IAC Reset BIT;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =SKIP ;
	strBitClearTitle         =RESET;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =84;

	btByteNumber             =29;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Error 43B Spark Test Done This Startup;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =DONE;
	strBitClearTitle         =NOT DONE;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =85;

	btByteNumber             =29;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =EST ERROR 43B (FAILED TEST);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FAILED;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- DIAG MODE WORD 2 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =95;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- DIAG MODE WORD 2 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =96;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Error 41 (Cylinder Select);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =97;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Error 25 (This Pass Indicated);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =98;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Ref Pulse in Current 100 mS;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =99;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Ref Pulse in LAST 100 mS;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =100;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Error 54 Locked In;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =101;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Error 54 Present;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =102;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Error 54A Passed;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =PASSED;
	strBitClearTitle         =FAIL;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =103;

	btByteNumber             =33;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =ESC Enabled via Coolant Tests;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Enabled;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =------- DIAG MODE WORD 4 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =104;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- DIAG MODE WORD 4 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =105;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Error 32 Active;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =106;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =107;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =EGR Diagnostic in Progress;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Testing...;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =108;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Option for First Pass;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =109;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Test Cycle Time;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =110;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =A/C First Pass with HI MPH;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =HI MPH;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =111;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =A/C Disabled via HI MPH;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =A/C Disabled;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =112;

	btByteNumber             =36;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Error 52 or 62 Present;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- MODE WORD 2 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =91;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- MODE WORD 2 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =123;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =124;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Error 14 or 15 This Startup;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =125;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Ref Pulse Occurred (6.25 mS);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Pulse YES;
	strBitClearTitle         =Pulse  NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =126;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =In CCM Mode;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =127;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =In Diagnostic Mode;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =DIAG MODE;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =128;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =In ALDL Mode;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ALDL MODE;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =129;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =High Battery Voltage;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =130;

	btByteNumber             =54;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Shift Light;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =------- TCC MODE WORD -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =131;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- TCC MODE WORD -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =133;

	btByteNumber             =55;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =TCC Locked;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Locked;
	strBitClearTitle         =UN-Locked;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =134;

	btByteNumber             =55;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Coast Release TPS Threshold In Use;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =135;

	btByteNumber             =55;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =4-3/4-2 DownShift In Progress;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =136;

	btByteNumber             =55;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Fourth Gear (Last Pass);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =137;

	btByteNumber             =55;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =TCC Locked for PassBy Noise;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Locked;
	strBitClearTitle         =Un-Locked;
}

{
	dwItemType               =2;
	strItemComments          =------- FMD BIT STATUS WORD -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =138;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- FMD BIT STATUS WORD -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =132;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Park/Neutral Switch;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =IN GEAR;
	strBitClearTitle         =PARK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =139;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =In 3rd or 4th Gear;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =My Trans showed switch normally ON, Yours "may" not.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =140;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =In 4th Gear;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =Low Gears;
	strBitClearTitle         =4th Gear;
}

{
	dwItemType               =2;
	strItemComments          =Originally was set for opposite but had indication always.;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =141;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Power Steering Cramp;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =OK;
	strBitClearTitle         =Cramp;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =142;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =143;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =Invert the reading if using an N.C. Switch;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =144;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =High A/C Pressure (If N.O.Switch);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =Normal;
	strBitClearTitle         =High PSI;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =145;

	btByteNumber             =56;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =A/C Clutch Engaged;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =------- MODE WORD 1 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =146;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- MODE WORD 1 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =147;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Spark Flag;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =RETARD;
	strBitClearTitle         =ADVANCE;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =148;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =HighWay Fuel Timer Enabled;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =149;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Interrupt Exceeded 6.25 mS;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =150;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =FAN 1 PID Steps Added;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =DONE;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =151;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =1st Pass with 1 Road Speed Pulse;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =152;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =A/C Clutch Indicator;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =OFF;
	strBitClearTitle         =ON;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =153;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =ByPass Check Enable;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =154;

	btByteNumber             =57;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Engine Running;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =------- NV MODE WORD  -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =155;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- NV MODE WORD  -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =156;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =o2 Sensor Ready;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =157;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Closed Loop Timer Done;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =158;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =NOT SURE IF THIS IS REVERSE ACTING ?;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =159;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Improper Shut Down;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =NO;
	strBitClearTitle         =YES;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =160;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =161;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =IAC Kickdown Enabled;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =162;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Warm KickDown Enabled;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =163;

	btByteNumber             =58;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Error 42 (EST Failure);
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERROR;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =------- CARS MODE WORD  -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =164;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- CARS MODE WORD  -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =165;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =CARS Disabled From LOW BARO;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =DISABLED;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =166;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =CARS Active;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =167;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =168;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =169;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Trans In 4th Gear;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =170;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Trans In 1st Gear;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =171;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Wait For VSS Reset;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =0;
	dwUniqueID               =172;

	btByteNumber             =59;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =NOT USED;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =------- CLCC MODE WORD  -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =173;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- CLCC MODE WORD  -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =175;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =BookKeeping Flip/Flop;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FLIP  :);
	strBitClearTitle         =FLOP :(;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =174;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Use F69 Alternate Table;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =176;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Idle Condition;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =IDLE;
	strBitClearTitle         =Off Idle;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =177;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Idle Spark, OverSpeed/UnderSpeed;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Under  Speed;
	strBitClearTitle         =Over    Speed;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =178;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =DFCO Stall Saver Enabled;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ENABLED;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =179;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Using KF93 Mult Trim, D-MAP A.E. Enable Threshold;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =        USING;
	strBitClearTitle         =NOT USING;
}

{
	dwItemType               =2;
	strItemComments          =Not sure if this is reversed;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =180;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Non-Vol Memory Bombed;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =OK;
	strBitClearTitle         =BOMBED;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =181;

	btByteNumber             =60;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Has Been In CL Once Since Start;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =------- AIR MODE WORD  -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =182;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- AIR MODE WORD  -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =183;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =100 mS Old CCP Purge ON;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =184;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =AIR Control/Divert;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =CONTROLLED;
	strBitClearTitle         =DIVERT;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =185;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =AIR to PORT (If Controlled);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =to PORT;
	strBitClearTitle         =Not to PORT;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =186;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Fan 1 Requested;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =187;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Fan 2 Requested;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =188;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             ="Old" Fan State was ON;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =189;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =All Fan 2 PID Steps Added;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =190;

	btByteNumber             =61;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Decel Enleanment Active;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =------- LCCP MODE WORD  -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =191;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- LCCP MODE WORD  -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =192;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =Canister Purge Active;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ON;
	strBitClearTitle         =OFF;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =193;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =1st Time REF to Engine Running;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =194;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Error Has Occurred;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =ERRORS;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =195;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =In 8192, Mode 4, Bypass Fuel Mode;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =196;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =Second Time Coolant;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =197;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Err 43A Voltage Check Indicated;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =198;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Warm Kick Down Request;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =199;

	btByteNumber             =62;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =F82 Time Out Finished;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =------- AIR/FUEL MODE WORD 1 -------;
	bSeparator               =1;
	bVisible                 =0;
	dwUniqueID               =200;

	btByteNumber             =0;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =------- AIR/FUEL MODE WORD 1 -------;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =1;
	strBitClearTitle         =0;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =201;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =0;
	strItemTitle             =In Single Fire Mode;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =202;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =1;
	strItemTitle             =Learn Enable;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =1;
	strBitSetTitle           =ENABLED;
	strBitClearTitle         =DISABLED;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =203;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =2;
	strItemTitle             =Deliver 0 Fuel (Single Fire);
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =204;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =3;
	strItemTitle             =Allow Single Fire Disable;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =YES;
	strBitClearTitle         =NO;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =205;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =4;
	strItemTitle             =VSS Failure;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =FAIL;
	strBitClearTitle         =OK;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =206;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =5;
	strItemTitle             =Slow 02 Rich/Lean;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Rich Slow;
	strBitClearTitle         =Lean Slow;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =207;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =6;
	strItemTitle             =Rich / Lean;
	bAlarmSetEnable          =0;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =RICH;
	strBitClearTitle         =LEAN;
}

{
	dwItemType               =2;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =208;

	btByteNumber             =63;
	btMessageNumber          =1;
	btBitNumber              =7;
	strItemTitle             =Closed Loop;
	bAlarmSetEnable          =1;
	bAlarmNotSetEnable       =0;
	strBitSetTitle           =Closed Loop;
	strBitClearTitle         =Open Loop;
}

//--------------------------------------------------------------------------------------
//---------------------------- LOOKUP TABLES ----------------------------------
//--------------------------------------------------------------------------------------

{
	dwItemType               =5;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =87;

	btDataType               =2;
	wTableSize               =256;
	wIndexSize               =4;
	strTableName             =Temp Lookup;
	dwReserved               =0;
	dwReserved               =0;
	pbtData                  =0, -40.00
				 4, -30.00
				 5, -25.00
				 8, -20.00
				 10, -15.00
				 14, -10.00
				 18, -5.00
				 24, 0.00
				 30, 5.00
				 37, 10.00
				 46, 15.00
				 56, 20.00
				 66, 25.00
				 78, 30.00
				 90, 35.00
				 103, 40.00
				 116, 45.00
				 129, 50.00
				 141, 55.00
				 153, 60.00
				 163, 65.00
				 174, 70.00
				 183, 75.00
				 190, 80.00
				 199, 85.00
				 205, 90.00
				 211, 95.00
				 216, 100.00
				 221, 105.00
				 225, 110.00
				 229, 115.00
				 232, 120.00
				 234, 125.00
				 237, 130.00
				 239, 135.00
				 241, 140.00
				 242, 145.00
				 243, 150.00
				 255, 200.00;
}

{
	dwItemType               =5;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =227;

	btDataType               =2;
	wTableSize               =256;
	wIndexSize               =4;
	strTableName             =EGT Deg F;
	dwReserved               =0;
	dwReserved               =0;
	pbtData                  =0, 0.00
				 1, 14.80
				 2, 21.80
				 3, 28.70
				 4, 35.70
				 5, 42.70
				 6, 49.70
				 7, 56.60
				 8, 63.60
				 9, 70.60
				 10, 77.60
				 11, 84.50
				 12, 91.50
				 13, 98.50
				 14, 105.50
				 15, 112.40
				 16, 119.40
				 17, 126.40
				 18, 133.40
				 19, 140.30
				 20, 147.30
				 21, 154.30
				 22, 161.30
				 23, 168.20
				 24, 175.20
				 25, 182.20
				 26, 189.20
				 27, 196.10
				 28, 203.10
				 29, 210.10
				 30, 217.10
				 31, 224.10
				 32, 231.00
				 33, 238.00
				 34, 245.00
				 35, 252.00
				 36, 258.90
				 37, 265.90
				 38, 272.90
				 39, 279.90
				 40, 286.80
				 41, 293.80
				 42, 300.80
				 43, 307.80
				 44, 314.70
				 45, 321.70
				 46, 328.70
				 47, 335.70
				 48, 342.60
				 49, 349.60
				 50, 356.60
				 51, 363.60
				 52, 370.50
				 53, 377.50
				 54, 384.50
				 55, 391.50
				 56, 398.40
				 57, 405.40
				 58, 412.40
				 59, 419.40
				 60, 426.30
				 61, 433.30
				 62, 440.30
				 63, 447.30
				 64, 454.20
				 65, 461.20
				 66, 468.20
				 67, 475.20
				 68, 482.20
				 69, 489.10
				 70, 496.10
				 71, 503.10
				 72, 510.10
				 73, 517.00
				 74, 524.00
				 75, 531.00
				 76, 538.00
				 77, 544.90
				 78, 551.90
				 79, 558.90
				 80, 565.90
				 81, 572.80
				 82, 579.80
				 83, 586.80
				 84, 593.80
				 85, 600.70
				 86, 607.70
				 87, 614.70
				 88, 621.70
				 89, 628.60
				 90, 635.60
				 91, 642.60
				 92, 649.60
				 93, 656.50
				 94, 663.50
				 95, 670.50
				 96, 677.50
				 97, 684.40
				 98, 691.40
				 99, 698.40
				 100, 705.40
				 101, 712.30
				 102, 719.30
				 103, 726.30
				 104, 733.30
				 105, 740.20
				 106, 747.20
				 107, 754.20
				 108, 761.20
				 109, 768.20
				 110, 775.10
				 111, 782.10
				 112, 789.10
				 113, 796.10
				 114, 803.00
				 115, 810.00
				 116, 817.00
				 117, 824.00
				 118, 830.90
				 119, 837.90
				 120, 844.90
				 121, 851.90
				 122, 858.80
				 123, 865.80
				 124, 872.80
				 125, 879.80
				 126, 886.70
				 127, 893.70
				 128, 900.70
				 129, 907.70
				 130, 914.60
				 131, 921.60
				 132, 928.60
				 133, 935.60
				 134, 942.50
				 135, 949.50
				 136, 956.50
				 137, 963.50
				 138, 970.40
				 139, 977.40
				 140, 984.40
				 141, 991.40
				 142, 998.30
				 143, 1005.30
				 144, 1012.30
				 145, 1019.30
				 146, 1026.20
				 147, 1033.20
				 148, 1040.20
				 149, 1047.20
				 150, 1054.20
				 151, 1061.10
				 152, 1068.10
				 153, 1075.10
				 154, 1082.10
				 155, 1089.00
				 156, 1096.00
				 157, 1103.00
				 158, 1110.00
				 159, 1116.90
				 160, 1123.90
				 161, 1130.90
				 162, 1137.90
				 163, 1144.80
				 164, 1151.80
				 165, 1158.80
				 166, 1165.80
				 167, 1172.70
				 168, 1179.70
				 169, 1186.70
				 170, 1193.70
				 171, 1200.60
				 172, 1207.60
				 173, 1214.60
				 174, 1221.60
				 175, 1228.50
				 176, 1235.50
				 177, 1242.50
				 178, 1249.50
				 179, 1256.40
				 180, 1263.40
				 181, 1270.40
				 182, 1277.40
				 183, 1284.30
				 184, 1291.30
				 185, 1298.30
				 186, 1305.30
				 187, 1312.30
				 188, 1319.20
				 189, 1326.20
				 190, 1333.20
				 191, 1340.20
				 192, 1347.10
				 193, 1354.10
				 194, 1361.10
				 195, 1368.10
				 196, 1375.00
				 197, 1382.00
				 198, 1389.00
				 199, 1396.00
				 200, 1402.90
				 201, 1409.90
				 202, 1416.90
				 203, 1423.90
				 204, 1430.80
				 205, 1437.80
				 206, 1444.80
				 207, 1451.80
				 208, 1458.70
				 209, 1465.70
				 210, 1472.70
				 211, 1479.70
				 212, 1486.60
				 213, 1493.60
				 214, 1500.60
				 215, 1507.60
				 216, 1514.50
				 217, 1521.50
				 218, 1528.50
				 219, 1535.50
				 220, 1542.40
				 221, 1549.40
				 222, 1556.40
				 223, 1563.40
				 224, 1570.40
				 225, 1577.30
				 226, 1584.30
				 227, 1591.30
				 228, 1598.30
				 229, 1605.20
				 230, 1612.20
				 231, 1619.20
				 232, 1626.20
				 233, 1633.10
				 234, 1640.10
				 235, 1647.10
				 236, 1654.10
				 237, 1661.00
				 238, 1668.00
				 239, 1675.00
				 240, 1682.00
				 241, 1688.90
				 242, 1695.90
				 243, 1702.90
				 244, 1709.90
				 245, 1716.80
				 246, 1723.80
				 247, 1730.80
				 248, 1737.80
				 249, 1744.70
				 250, 1751.70
				 251, 1758.70
				 252, 1765.70
				 253, 1772.60
				 254, 1779.60
				 255, 1786.60;
}

{
	dwItemType               =5;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =228;

	btDataType               =2;
	wTableSize               =256;
	wIndexSize               =4;
	strTableName             =EGT Deg C;
	dwReserved               =0;
	dwReserved               =0;
	pbtData                  =0, -17.78
				 1, -9.56
				 2, -5.67
				 3, -1.83
				 4, 2.06
				 5, 5.94
				 6, 9.83
				 7, 13.67
				 8, 17.56
				 9, 21.44
				 10, 25.33
				 11, 29.17
				 12, 33.06
				 13, 36.94
				 14, 40.83
				 15, 44.67
				 16, 48.56
				 17, 52.44
				 18, 56.33
				 19, 60.17
				 20, 64.06
				 21, 67.94
				 22, 71.83
				 23, 75.67
				 24, 79.56
				 25, 83.44
				 26, 87.33
				 27, 91.17
				 28, 95.06
				 29, 98.94
				 30, 102.83
				 31, 106.72
				 32, 110.56
				 33, 114.44
				 34, 118.33
				 35, 122.22
				 36, 126.06
				 37, 129.94
				 38, 133.83
				 39, 137.72
				 40, 141.56
				 41, 145.44
				 42, 149.33
				 43, 153.22
				 44, 157.06
				 45, 160.94
				 46, 164.83
				 47, 168.72
				 48, 172.56
				 49, 176.44
				 50, 180.33
				 51, 184.22
				 52, 188.06
				 53, 191.94
				 54, 195.83
				 55, 199.72
				 56, 203.56
				 57, 207.44
				 58, 211.33
				 59, 215.22
				 60, 219.06
				 61, 222.94
				 62, 226.83
				 63, 230.72
				 64, 234.56
				 65, 238.44
				 66, 242.33
				 67, 246.22
				 68, 250.11
				 69, 253.94
				 70, 257.83
				 71, 261.72
				 72, 265.61
				 73, 269.44
				 74, 273.33
				 75, 277.22
				 76, 281.11
				 77, 284.94
				 78, 288.83
				 79, 292.72
				 80, 296.61
				 81, 300.44
				 82, 304.33
				 83, 308.22
				 84, 312.11
				 85, 315.94
				 86, 319.83
				 87, 323.72
				 88, 327.61
				 89, 331.44
				 90, 335.33
				 91, 339.22
				 92, 343.11
				 93, 346.94
				 94, 350.83
				 95, 354.72
				 96, 358.61
				 97, 362.44
				 98, 366.33
				 99, 370.22
				 100, 374.11
				 101, 377.94
				 102, 381.83
				 103, 385.72
				 104, 389.61
				 105, 393.44
				 106, 397.33
				 107, 401.22
				 108, 405.11
				 109, 409.00
				 110, 412.83
				 111, 416.72
				 112, 420.61
				 113, 424.50
				 114, 428.33
				 115, 432.22
				 116, 436.11
				 117, 440.00
				 118, 443.83
				 119, 447.72
				 120, 451.61
				 121, 455.50
				 122, 459.33
				 123, 463.22
				 124, 467.11
				 125, 471.00
				 126, 474.83
				 127, 478.72
				 128, 482.61
				 129, 486.50
				 130, 490.33
				 131, 494.22
				 132, 498.11
				 133, 502.00
				 134, 505.83
				 135, 509.72
				 136, 513.61
				 137, 517.50
				 138, 521.33
				 139, 525.22
				 140, 529.11
				 141, 533.00
				 142, 536.83
				 143, 540.72
				 144, 544.61
				 145, 548.50
				 146, 552.33
				 147, 556.22
				 148, 560.11
				 149, 564.00
				 150, 567.89
				 151, 571.72
				 152, 575.61
				 153, 579.50
				 154, 583.39
				 155, 587.22
				 156, 591.11
				 157, 595.00
				 158, 598.89
				 159, 602.72
				 160, 606.61
				 161, 610.50
				 162, 614.39
				 163, 618.22
				 164, 622.11
				 165, 626.00
				 166, 629.89
				 167, 633.72
				 168, 637.61
				 169, 641.50
				 170, 645.39
				 171, 649.22
				 172, 653.11
				 173, 657.00
				 174, 660.89
				 175, 664.72
				 176, 668.61
				 177, 672.50
				 178, 676.39
				 179, 680.22
				 180, 684.11
				 181, 688.00
				 182, 691.89
				 183, 695.72
				 184, 699.61
				 185, 703.50
				 186, 707.39
				 187, 711.28
				 188, 715.11
				 189, 719.00
				 190, 722.89
				 191, 726.78
				 192, 730.61
				 193, 734.50
				 194, 738.39
				 195, 742.28
				 196, 746.11
				 197, 750.00
				 198, 753.89
				 199, 757.78
				 200, 761.61
				 201, 765.50
				 202, 769.39
				 203, 773.28
				 204, 777.11
				 205, 781.00
				 206, 784.89
				 207, 788.78
				 208, 792.61
				 209, 796.50
				 210, 800.39
				 211, 804.28
				 212, 808.11
				 213, 812.00
				 214, 815.89
				 215, 819.78
				 216, 823.61
				 217, 827.50
				 218, 831.39
				 219, 835.28
				 220, 839.11
				 221, 843.00
				 222, 846.89
				 223, 850.78
				 224, 854.67
				 225, 858.50
				 226, 862.39
				 227, 866.28
				 228, 870.17
				 229, 874.00
				 230, 877.89
				 231, 881.78
				 232, 885.67
				 233, 889.50
				 234, 893.39
				 235, 897.28
				 236, 901.17
				 237, 905.00
				 238, 908.89
				 239, 912.78
				 240, 916.67
				 241, 920.50
				 242, 924.39
				 243, 928.28
				 244, 932.17
				 245, 936.00
				 246, 939.89
				 247, 943.78
				 248, 947.67
				 249, 951.50
				 250, 955.39
				 251, 959.28
				 252, 963.17
				 253, 967.00
				 254, 970.89
				 255, 974.78;
}

{
	dwItemType               =5;
	strItemComments          =<Comments>;
	bSeparator               =0;
	bVisible                 =1;
	dwUniqueID               =229;

	btDataType               =2;
	wTableSize               =256;
	wIndexSize               =4;
	strTableName             =EGT CALibrated Table;
	dwReserved               =0;
	dwReserved               =0;
	pbtData                  =				 29, 212.00
				 55, 392.00
				 81, 572.00
				 107, 752.00
				 134, 932.00
				 161, 1112.00
				 187, 1292.00
				 214, 1472.00
				 239, 1652.00;
}

